/*
 * Decompiled with CFR 0.152.
 */
package spark;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Filter;
import spark.FilterImpl;
import spark.Request;
import spark.Response;
import spark.Route;
import spark.RouteImpl;
import spark.Spark;
import spark.route.RouteMatcherFactory;
import spark.route.SimpleRouteMatcher;
import spark.servlet.SparkFilter;
import spark.webserver.SparkServer;
import spark.webserver.SparkServerFactory;

public abstract class SparkBase {
    private static final Logger LOG = LoggerFactory.getLogger((String)"spark.Spark");
    public static final int SPARK_DEFAULT_PORT = 4567;
    protected static final String DEFAULT_ACCEPT_TYPE = "*/*";
    protected static boolean initialized = false;
    protected static int port = 4567;
    protected static String ipAddress = "0.0.0.0";
    protected static String keystoreFile;
    protected static String keystorePassword;
    protected static String truststoreFile;
    protected static String truststorePassword;
    protected static String staticFileFolder;
    protected static String externalStaticFileFolder;
    protected static SparkServer server;
    protected static SimpleRouteMatcher routeMatcher;
    private static boolean runFromServlet;
    private static boolean servletStaticLocationSet;
    private static boolean servletExternalStaticLocationSet;

    public static synchronized void setIpAddress(String ipAddress) {
        if (initialized) {
            SparkBase.throwBeforeRouteMappingException();
        }
        Spark.ipAddress = ipAddress;
    }

    public static synchronized void ipAddress(String ipAddress) {
        if (initialized) {
            SparkBase.throwBeforeRouteMappingException();
        }
        Spark.ipAddress = ipAddress;
    }

    public static synchronized void setPort(int port) {
        if (initialized) {
            SparkBase.throwBeforeRouteMappingException();
        }
        Spark.port = port;
    }

    public static synchronized void port(int port) {
        if (initialized) {
            SparkBase.throwBeforeRouteMappingException();
        }
        Spark.port = port;
    }

    public static synchronized void setSecure(String keystoreFile, String keystorePassword, String truststoreFile, String truststorePassword) {
        if (initialized) {
            SparkBase.throwBeforeRouteMappingException();
        }
        if (keystoreFile == null) {
            throw new IllegalArgumentException("Must provide a keystore file to run secured");
        }
        Spark.keystoreFile = keystoreFile;
        Spark.keystorePassword = keystorePassword;
        Spark.truststoreFile = truststoreFile;
        Spark.truststorePassword = truststorePassword;
    }

    public static synchronized void secure(String keystoreFile, String keystorePassword, String truststoreFile, String truststorePassword) {
        if (initialized) {
            SparkBase.throwBeforeRouteMappingException();
        }
        if (keystoreFile == null) {
            throw new IllegalArgumentException("Must provide a keystore file to run secured");
        }
        Spark.keystoreFile = keystoreFile;
        Spark.keystorePassword = keystorePassword;
        Spark.truststoreFile = truststoreFile;
        Spark.truststorePassword = truststorePassword;
    }

    public static synchronized void staticFileLocation(String folder) {
        if (initialized && !runFromServlet) {
            SparkBase.throwBeforeRouteMappingException();
        }
        staticFileFolder = folder;
        if (!servletStaticLocationSet) {
            if (runFromServlet) {
                SparkFilter.configureStaticResources(staticFileFolder);
                servletStaticLocationSet = true;
            }
        } else {
            LOG.warn("Static file location has already been set");
        }
    }

    public static synchronized void externalStaticFileLocation(String externalFolder) {
        if (initialized && !runFromServlet) {
            SparkBase.throwBeforeRouteMappingException();
        }
        externalStaticFileFolder = externalFolder;
        if (!servletExternalStaticLocationSet) {
            if (runFromServlet) {
                SparkFilter.configureExternalStaticResources(externalStaticFileFolder);
                servletExternalStaticLocationSet = true;
            }
        } else {
            LOG.warn("External static file location has already been set");
        }
    }

    private static void throwBeforeRouteMappingException() {
        throw new IllegalStateException("This must be done before route mapping has begun");
    }

    private static boolean hasMultipleHandlers() {
        return staticFileFolder != null || externalStaticFileFolder != null;
    }

    public static synchronized void stop() {
        if (server != null) {
            routeMatcher.clearRoutes();
            server.stop();
        }
        initialized = false;
    }

    static synchronized void runFromServlet() {
        runFromServlet = true;
        if (!initialized) {
            routeMatcher = RouteMatcherFactory.get();
            initialized = true;
        }
    }

    protected static RouteImpl wrap(String path, Route route) {
        return SparkBase.wrap(path, DEFAULT_ACCEPT_TYPE, route);
    }

    protected static RouteImpl wrap(String path, String acceptType, final Route route) {
        if (acceptType == null) {
            acceptType = DEFAULT_ACCEPT_TYPE;
        }
        RouteImpl impl = new RouteImpl(path, acceptType){

            @Override
            public Object handle(Request request, Response response) throws Exception {
                return route.handle(request, response);
            }
        };
        return impl;
    }

    protected static FilterImpl wrap(String path, Filter filter) {
        return SparkBase.wrap(path, DEFAULT_ACCEPT_TYPE, filter);
    }

    protected static FilterImpl wrap(String path, String acceptType, final Filter filter) {
        if (acceptType == null) {
            acceptType = DEFAULT_ACCEPT_TYPE;
        }
        FilterImpl impl = new FilterImpl(path, acceptType){

            @Override
            public void handle(Request request, Response response) throws Exception {
                filter.handle(request, response);
            }
        };
        return impl;
    }

    protected static void addRoute(String httpMethod, RouteImpl route) {
        SparkBase.init();
        routeMatcher.parseValidateAddRoute(httpMethod + " '" + route.getPath() + "'", route.getAcceptType(), route);
    }

    protected static void addFilter(String httpMethod, FilterImpl filter) {
        SparkBase.init();
        routeMatcher.parseValidateAddRoute(httpMethod + " '" + filter.getPath() + "'", filter.getAcceptType(), filter);
    }

    private static synchronized void init() {
        if (!initialized) {
            routeMatcher = RouteMatcherFactory.get();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    server = SparkServerFactory.create(SparkBase.hasMultipleHandlers());
                    server.ignite(ipAddress, port, keystoreFile, keystorePassword, truststoreFile, truststorePassword, staticFileFolder, externalStaticFileFolder);
                }
            }).start();
            initialized = true;
        }
    }

    static {
        staticFileFolder = null;
        externalStaticFileFolder = null;
    }
}

